<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

$phpCacheControl = <<<EOD
<?php @include_once("$adlogger_doc_path/track/cache_control.php"); ?>
EOD;
?>
	<h1 id="cache-control">PHP Cache-Control Code</h1>
	<p>The Cache-Control code is very important if you're using the PHP Wrapping Code. It forces the web page to check if ads should be shown every time a visitor reloads your page. Ordinarily, your visitor's browser would "cache" the page in order to make it load faster. This means that it doesn't reload or recheck to see if they've clicked on any ads. To combat this problem, you can put a small snippet of code at the top of each of your web pages.</p>
	<p>This code must be placed before any output is sent to the browser. This usually means it's placed before the &lt;doctype...&gt; and &lt;html&gt; opening code.</p>
<form action="#">
	<fieldset>
	<legend>Cache-Control Code</legend>
	<div align="center">
		<textarea name="cache-control" cols="<?php echo strlen($phpCacheControl); ?>" rows="1" onclick="this.select();" readonly="readonly"><?php
			echo $phpCacheControl;
		?></textarea>
	</div>
	</fieldset>
</form>